Hot Topic

# Review of precision cancer medicine: Evolution of the treatment paradigm

Apostolia M. Tsimberidoua,⁎ , Elena Fountzilasb , Mina Nikanjamc , Razelle Kurzrockc

a The University of Texas MD Anderson Cancer Center, Department of Investigational Cancer Therapeutics, Houston, TX b Department of Medical Oncology, Euromedica General Clinic, Thessaloniki, Greece c Center for Personalized Cancer Therapy and Division of Hematology and Oncology, UC San Diego Moores Cancer Center, San Diego, CA, USA

# A R T I C L E I N F O

# A B S T R A C T

Keywords:   
ctDNA   
Personalized   
Precision   
Molecular profile   
Matched therapy   
Genomic landscape

In recent years, biotechnological breakthroughs have led to identification of complex and unique biologic features associated with carcinogenesis. Tumor and cell-free DNA profiling, immune markers, and proteomic and RNA analyses are used to identify these characteristics for optimization of anticancer therapy in individual patients. Consequently, clinical trials have evolved, shifting from tumor type-centered to gene-directed, histology-agnostic, with innovative adaptive design tailored to biomarker profiling with the goal to improve treatment outcomes. A plethora of precision medicine trials have been conducted. The majority of these trials demonstrated that matched therapy is associated with superior outcomes compared to non-matched therapy across tumor types and in specific cancers. To improve the implementation of precision medicine, this approach should be used early in the course of the disease, and patients should have complete tumor profiling and access to effective matched therapy. To overcome the complexity of tumor biology, clinical trials with combinations of gene-targeted therapy with immune-targeted approaches (e.g., checkpoint blockade, personalized vaccines and/ or chimeric antigen receptor T-cells), hormonal therapy, chemotherapy and/or novel agents should be considered. These studies should target dynamic changes in tumor biologic abnormalities, eliminating minimal residual disease, and eradicating significant subclones that confer resistance to treatment. Mining and expansion of real-world data, facilitated by the use of advanced computer data processing capabilities, may contribute to validation of information to predict new applications for medicines. In this review, we summarize the clinical trials and discuss challenges and opportunities to accelerate the implementation of precision oncology.

# Background

The rapidly expanding body of knowledge about the roles of genomics and the immune system in cancer has enabled the development of therapies targeted to specific molecular alterations or other biologic characteristics, such as those implicated in immune suppression. However, genomics has also revealed a complicated reality about malignancies that requires a major shift in the therapy paradigm: away from tumor type-centered and toward gene-directed, histology-agnostic treatment, which is individualized for each patient on the basis of biomarker analysis. This paradigm shift is reflected by the emergence of precision medicine trials with innovative design [1–21]. Next-generation sequencing (NGS) of advanced cancers has demonstrated that genomic alterations do not fall neatly into categories defined by the tumor organ of origin. Furthermore, metastatic tumors harbor tremendously complex and individually unique genomic and immune landscapes [22,23]. Therefore, in order to target malignancies with “precision,” treatment needs to be personalized.

Historically, phase II and III oncology clinical trials have measured outcomes histologically, but histological assessment cannot always capture the effects of gene-targeted agents or immunotherapy. Precision medicine approaches analyze patients’ circulating DNA (liquid biopsy), as well as immune markers and other biologic features, to assess efficacy and make treatment decisions. Genomic biomarkers have been the most successful to date, but other biomarkers, including protein assays and transcriptomics, are being developed and tested [13,24,25]. Several molecular alterations have been identified using sequencing and high-throughput technologies and have led to the approval of targeted agents by the Food and Drug Administration (FDA) [26,27]. Importantly, in recent years, the precision medicine paradigm has embraced immunotherapy and its interaction with genomics, as genomic characteristics, such as mismatch repair gene defects, are critical predictors of checkpoint blockade response [28–30].

Herein, we review the rapid evolution of precision medicine in oncology and, in particular, the challenge and opportunity that genomic science has revealed vis-à-vis the need for ${ } ^ { 6 6 } \mathrm { N } .$ -of-1” treatments. This treatment model does not conform to either canonical trial design or clinical practice, which seek to find commonalities between patients and treat them alike; instead, its goal is to provide optimized individualized treatment for each patient on the basis of biomarker analysis.

# History

Survival improvement with gene- or immune-directed therapy was accelerated by several major discoveries. In particular, the introduction of imatinib mesylate (Abl tyrosine kinase inhibitor) for patients with Philadelphia chromosome [t(9;22)]–positive chronic myelogenous leukemia producing the enzymatically aberrant Bcr-Abl [31,32] resulted in near-normal life expectancy for patients with this previously fatal leukemia.

In 2001, the human genome was sequenced [33]. Although this milestone represented an arduous and tremendously expensive endeavour, both the price and time required for sequencing have decreased precipitously, with technology advancing in a manner unparalleled in human history. A plethora of first- and second-generation precision medicine trials have since been conducted (Tables 1 and 2). They include, but are not limited to, the first pan-histology biomarkerdriven trial using mostly protein markers [1], the prospective molecular profiling of patients with advanced cancer in the phase I clinical trials setting (IMPACT trial) [2,4], the SHIVA randomized trial [5], trials assessing customized combinations [6,12], and trials including transcriptomics [13].

# Innovative clinical trial designs for precision medicine

Traditionally, oncology trials are drug-centered, aiming to identify common attributes among patients (e.g., their tumor type or, more recently, a shared genomic abnormality) and fit them into a trial with a specific drug regimen. The large variability in genomic subgroups, microenvironment, baseline characteristics, comorbidities, and other covariates resulted in tumor-specific clinical studies encompassing a tremendously heterogeneous population in histology-specific, gene-agnostic trials. Phase III randomized trials were often critical for regulatory approval of a novel agent/regimen, especially since the antitumor activity of a new drug/regimen was frequently only marginally better than the comparator arm (usually, conventional therapy), perhaps because the regimen was effective in only a small subgroup of the diverse population represented by any specific histology.

Basket, umbrella, platform, octopus, and master protocols

More recently, basket designs have emerged that target a common genetic defect [27]. The $7 5 \%$ objective response rate noted across tumor types with larotrectinib, which targets NTRK fusions, best exemplifies the potential of the basket gene-directed, histology-agnostic model, though other single-gene targets have proven much less responsive [27]. Umbrella trials involve a single histology and different treatments based on the genomic alterations in patient subgroups [34]. Other trial designs include platform trials, which use a single analytic technique, such as NGS, to identify genomic or other biomarkers in tumors with multiple histologies; octopus trials (also referred to as “complete phase I trials”) that have multiple arms testing different combinations featuring a particular drug; and master protocols, which encompass trials with several histologic arms (previously, “broad phase II trials”) or multiple platform, basket, or umbrella trials or sub-trials [2–4,6] Randomization has also evolved, with the emergence of Bayesian adaptation, which allows dynamic modifications of randomization based on small numbers of patients and real-time outcomes.

From drug-centered to patient-centered studies

The ultimate goal of precision medicine is an individualized, patient-centered (rather than drug-centered) trial based on the best available biomarkers. In “N-of-1” trials, each patient’s treatment is considered separately on the basis of molecular, immune, and other biologic characteristics. These trials involve customized drug combinations tailored to individual patients [12]. Determining efficacy in “Nof-1” trials requires assessing the “strategy” of matching patients to drugs, rather than treatments, which differ from patient to patient.

# Real-world data

With advanced computer data “processing” capabilities, real-world registries and data mining are expanding. Two drug approvals by the FDA were based, at least in part, on such data: pembrolizumab for any solid tumor with a mismatch repair gene defect (https://www.fda.gov/ Drugs/InformationOnDrugs/ApprovedDrugs/ucm56004”0.htm) and palbociclib for male breast cancer (https://www.fda.gov/NewsEvents/ Newsroom/PressAnnouncements/ucm635276.htm). The stunning possibility exists that real-world data, if confirmed to accurately portray the anticipated results of prospective trials, will dramatically accelerate the drug approval process.

# Genomic and other biomarkers

Genomics has been the cornerstone of precision medicine studies. Beyond genomics, RNA and protein profiling, with proteins being the effectors of signaling, also appear to be important in mediating biologic impact. Interestingly, matching patients to drugs on the basis of genomics has proven more effective in improving outcome than matching on the basis of protein assays, perhaps for technical reasons [24]. Despite the current practical limitations, protein and transcript assays may provide essential information when integrated with genomics [13]. Recently, panels that incorporate immune signatures, based on DNA, RNA, and/or proteins, have also gained clinical significance [35].

# Genomics

Given the advances in NGS technologies and the large number of laboratories in the US that perform Clinical Laboratory Improvement Amendments (CLIA)-certified NGS, optimization of the accuracy, reproducibility, and standardization of sequencing methods; variant annotation; and data interpretation is critical. Guidelines for the validation of NGS panels [36] and the interpretation and reporting of genomic variants have been developed [37]. Although whole-genome sequencing is not yet the standard practice in the clinic, the FDA has approved two NGS panels that include hundreds of genes [38].

Most genomic sequencing involves tissue, but blood-derived circulating tumor DNA (ctDNA), circulating tumor cells [39], and exosomes [40] are increasingly used, with the latter two reflecting the contents of live cells.

# Blood-derived cell-free DNA analysis

Clinical-grade ctDNA testing, which is non-invasive and reflects tumor heterogeneity (because tumor DNA may be leaked into the bloodstream from multiple metastatic lesions), is increasingly being used to select anti-cancer therapy and to monitor subclone dynamics during treatment [41,42]. The discordance noted in some cases between results of ctDNA testing and tumor tissue genotyping analysis [43] could reflect technical issues but might be attributable to the following biologic reasons: (i) tumor NGS measures genomics in the small piece of tissue biopsied while ctDNA assesses shed DNA from multiple sites; (ii) ctDNA is associated with tumor load and can be detected at low levels.

<html><body><table><tr><td>Year First/Last author</td><td>Trial name</td><td>Trial type</td><td>No of pts screened (N)</td><td>Proportion of pts.matched</td><td>Biomarker(s)</td><td>Outcome</td><td>Institute(s)</td><td>Comments</td></tr><tr><td colspan="9"> Diverse treatment-refractory tumor types</td></tr><tr><td>2010[1] Von Hoff D Penny R</td><td>Bisgrove</td><td>Prospective, navigational</td><td>86</td><td>77%</td><td>IHC,FISH, microarray</td><td>27% of 66 matched pts had a PFS2/PFS1 ratio*US ≥1.3 (95% CI, 17% t 38%; p = 0.007).</td><td>(9 sites)</td><td></td></tr><tr><td>2012[2] Tsimberidou A Kurzrock R</td><td>IMPACT, first cohort</td><td>Registry type, Navigational</td><td>1144</td><td>15%</td><td>PCR-based genomics, 9 genes</td><td>Matched vs unmatched RR,27% vs.5%(p&lt; 0.0001), TTF: median,5.2 vs.2.2 mos (p&lt; 0.0001)</td><td>MD Anderson Cancer Center</td><td></td></tr><tr><td>2014[3] Tsimberidou A Berry D</td><td>IMPACT,second cohort</td><td>Registry type, navigational</td><td>1276</td><td>11%</td><td>PCR-based genomics, 18-50 genes</td><td>OS: median,13.4 vs.9.0 mos (p = 0.017) Matched vs unmatched RR,11.9% vs.5% (p &lt; 0.0001), PFS: median,3.9 vs.2.2 mos,(p = 0.001); OS: median,11.4 vs.8.6 mos (p = 0.04)</td><td>MD Anderson Cancer Center</td><td>2-month landmark analyses, matched therapy group: Os, responders 30.5 months vs. 11.3 months for non-responders</td></tr><tr><td>2017[4] Tsimberidou AM</td><td></td><td>IMPACT,third cohortRegistry type, navigational</td><td>1436</td><td>27%</td><td>PCR-based genomics and NGS,</td><td>Matched vs unmatched Higher rates of ORR (p = 0.0099),TTF</td><td>MD Anderson Cancer Center</td><td>(p = 0.01).</td></tr><tr><td>Kurzrock R 2015[5] Le Tourneau Paoletti X</td><td>SHIVA</td><td>Prospective, randomized</td><td>741</td><td>13%</td><td>11 to 182 genes Targeted NGS,~50 genes</td><td>(p = 0.0015),and OS (p = 0.04) PFS not improved withmatched therapy (p = 0.41)</td><td>Institut Curie,8 French sites</td><td>~80% of patients received single agent hormone modulators or everolimus</td></tr><tr><td>2016[6] Schwaederle M Kurzrock R</td><td>PREDICT</td><td>Registry type</td><td>347</td><td>25%</td><td>NGS,182 or 236 genes</td><td>Matched vs unmatched Higher rates of SD ≥ 6 months/PR/CR (p = 0.02)and PFS (p &lt; 0.04). Higher matching scores correlated with better OS: 15.7</td><td>University of California San Diego</td><td></td></tr><tr><td>2016[7] Wheler JJ Kurzrock R</td><td>MD Anderson Personalized Cancer Therapy Initiative</td><td>Prospective, navigational</td><td>500</td><td>24%</td><td>NGS, 236 genes</td><td>vs 10.6 mos (p = 0.04) Higher matching scores correlated with higher rates of SD ≥ 6 months/PR/CR (p = 0.024), TTF (p = 0.0003),and OS (p = 0.05)</td><td>MD Anderson Cancer Center</td><td></td></tr><tr><td>2016[8] Stockley TL Bedard PL 2017[9]</td><td>IMPACT/ COMPACT</td><td>Prospective</td><td>1893</td><td>5%</td><td>Hot spot panel, 23 genes</td><td>Matched vs unmatched Higher ORR:19% vs 9%, (p = 0.026).</td><td>Princess Margaret, Canadian centers</td><td></td></tr><tr><td>Massard C Soria JC 2018[10] Hainsworth JD</td><td>MyPathway</td><td></td><td></td><td></td><td>Targeted NGS, 40-75 genes; aCGH; RNAseq Genomic testing via</td><td>PFS2/PFS1 ratio*was &gt; 1.3 in 33% (63/193) of patients Matched patients, ORR:</td><td>Institut Gustave Roussy Multiple sites,</td><td>251 patients enrolled; 230 were</td></tr><tr><td>Kurzrock R 2019[11]</td><td></td><td>2 basket</td><td></td><td></td><td>any CLIA lab</td><td>All, 23% HER2-altered,38% BRAF-altered,43%</td><td>Genentech</td><td>treated; however,how many wer screened pre-enrollment is unknown</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>Diego and Avera</td><td></td></tr><tr><td></td><td></td><td>navigational</td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Rodon J</td><td></td><td>Prospective,</td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Sicklick J</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>2019[12]</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Blay JY</td><td></td><td></td><td></td><td></td><td></td><td>RR = 13% (23 of 182 treated)</td><td></td><td></td></tr><tr><td>Tredan O</td><td>Profiler</td><td>Prospective</td><td>2579</td><td>6%</td><td>NGS, 69 genes</td><td></td><td>Four institutes</td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>(France)</td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>I-PREDICT</td><td>Prospective,</td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td>149</td><td>49%</td><td>NGS,315 genes;</td><td>Higher matching scores correlated with</td><td>University of</td><td>First trial to administer customiz</td></tr><tr><td></td><td></td><td>navigational</td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Kurzrock R</td><td></td><td></td><td></td><td></td><td>ctDNA；</td><td>increased rates of SD ≥ 6 months/PR/CR: 50%California San</td><td></td><td>combination therapy(&quot;N-of-1”</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td>PDL1 IHC</td><td>vs 22.4% (p = 0.028),PFS (p = 0.0004),and</td><td></td><td>matching)</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td>OS (p = 0.038)</td><td></td><td></td></tr><tr><td>2019[13]</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>WINTHER</td><td></td><td>303</td><td>35%</td><td>NGS, 236 genes;</td><td>Higher matching scores correlated with longer</td><td>Five countries</td><td>First solid tumor trial to include</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td>PFS (p = 0.005) and OS (p = 0.03)</td><td></td><td></td></tr><tr><td>Kurzrock R</td><td></td><td></td><td></td><td></td><td>transcriptomics</td><td></td><td>(Spain, Israel,</td><td>transcriptomics</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>France, Canada,</td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>US)</td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>It is unclear how many patients</td></tr><tr><td>Specific tumors-Lung 2011[14] Kim ES</td><td></td><td>Prospective,</td><td></td><td></td><td>11 biomarkers</td><td>8-week disease control rate, 46%</td></table></body></html>

<html><body><table><tr><td>Year First/Last author</td><td>Trial name</td><td>Trial type</td><td>No of pts screened (N)</td><td>Proportion of pts.matched</td><td>Biomarker(s)</td><td>Outcome</td><td>Institute(s)</td><td>Comments</td></tr><tr><td>2014[15] Kris MG Bunn PA</td><td>Lung cancer mutation consortium</td><td>Prospective</td><td>1537</td><td>17%</td><td>Multiplex genotyping, 10 genes</td><td>Improved OS with matched vs unmatched therapy (p = 0.006)</td><td>14 US sites</td><td></td></tr><tr><td>2016[16] Aisner D Kwiatkowski DJ</td><td>Lung Cancer Mutation Consortium II</td><td>Prospective</td><td>904</td><td>12%</td><td>NGS, minimum of 14 genes</td><td>Improved survival with matched therapy (p&lt;0.001)</td><td>16 sites</td><td></td></tr><tr><td>2016[17] Papadimitrako- poulou V Herbst RS</td><td>BATTLE-2</td><td>Prospective, adaptive, randomized</td><td>334</td><td>Non-applicable</td><td>ALK,FISH, EGFR,and KRAS Sanger sequencing</td><td>KRAS alterations: longer PFS without erlotinib (p = O.O4); KRAS wild-type tumors: longer OSCancer Center on erlotinib (p = 0.03)</td><td>MD Anderson</td><td></td></tr><tr><td>Specific tumors-Breast 2012[18] Esserman LJ</td><td>I-SPY 1</td><td>Neoadjuvant, correlative</td><td>237</td><td>Non-applicableIHC</td><td></td><td>pCR differs by subset</td><td>Multiple US sites</td><td>Aim was to develop biomarkers of response to conventional therapy</td></tr><tr><td>Hylton N 2015[19] Andre F Bonnefoi H</td><td>SAFIR01/ UNICANCER</td><td>Prospective</td><td>423</td><td>13%</td><td>Sanger sequencing (2 genes: PIK3CA and</td><td>Matched group,ORR 9%</td><td>18 centers in France</td><td></td></tr><tr><td>2016[20,21] Park JW Berry DA</td><td>I-SPY 2</td><td>Phase 2 adaptive design,</td><td>Non- applicable</td><td></td><td>AKT); aCGH Non-applicableIHC, Mammaprint</td><td>Improved pCR rates in 2 study arms with drug addition:</td><td>Healthcare Quantum-Leap</td><td>Results for 2 arms of I-SPY-2 study available</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td>HER2+,hormone receptor-negative: neratinib</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td>plus standard therapy (N = 115) vs standard</td><td>(US sites)</td><td></td></tr><tr><td>Rugo HS</td><td></td><td>neoadjuvant</td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Esserman LJ</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td>therapy (N = 78):56% vs 33%</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td>Triple-negative: veliparib plus carboplatin</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td>(N = 72) with standard therapy Vs standard</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td>therapy (N = 44): 51% vs 26%</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Specific tumors-Gastric</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>2019 [120]</td><td></td><td></td><td>772</td><td>14%</td><td>NGS,IHC,PDL1,MMR</td><td>Improved PFS and OS with matched vs</td><td>Republic of Korea</td><td>The trial included 1O phase II trials</td></tr><tr><td></td><td>VICTORY</td><td>Prospective</td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Lee J</td><td></td><td></td><td></td><td></td><td>and EBV status</td><td></td><td></td><td>that operated independently (based</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td>unmatched therapy (p &lt; 0.0001)</td><td></td><td></td></tr><tr><td>WK Kang</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>on eight biomarkers)</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td></table></body></html>

<html><body><table><tr><td>Year started</td><td>Trial name</td><td>Trial type</td><td>Cancer type</td><td>Biomarker</td><td>NCT number</td><td>Institute(s)</td><td>Comment</td></tr><tr><td>2010 [20,21]</td><td>I-SPY 2</td><td>Prospective randomized</td><td>Neoadjuvant breast cancer</td><td>IHC, Mammaprint</td><td>NCT01042379</td><td>Quantum-Leap Healthcare, US sites</td><td>Ongoing study with preliminary results (</td></tr><tr><td>2012 [121]</td><td>SPECTA-Color</td><td>Registry type</td><td>Advanced colorectal cancer</td><td>NGS/IHC</td><td>NCT01723969</td><td>European hospitals</td><td>Table 1)</td></tr><tr><td>2013</td><td>MPACT</td><td>Prospective</td><td>Advanced cancer</td><td>NGS</td><td>NCT01827384 NCI, US sites</td><td></td><td></td></tr><tr><td>2014[122]</td><td>ALCHEMIST</td><td>Prospective</td><td>Earlystage non-small celung cancer</td><td>Direct sequencing,FISH,CLIAried genotyping</td><td>NCT02194738NCI, US sites</td><td></td><td></td></tr><tr><td>2014 [34]</td><td>Lung-MAP</td><td>Prospective</td><td>Advanced squamous cell lung cancer</td><td>NGS</td><td>NCT02154490 NCI, US sites NCT02785913 NCT02965378</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td>NCT02785939 NCT02785952 NCT02926638</td><td></td><td></td></tr><tr><td>2014[123]</td><td>AURORA</td><td>Registry type</td><td>Metastatic breast cancer</td><td>NGS/RNAseq</td><td>NCT02766335</td><td></td><td></td></tr><tr><td>2014[124]</td><td>Signature</td><td>Prospective</td><td>Advanced cancers</td><td></td><td>NCT02102165</td><td>Institut Jules Bordet, Brussels, Belgium, European hospitals</td><td></td></tr><tr><td>2014[10]</td><td></td><td></td><td></td><td>Variable</td><td>CT02187783 NCT02186821</td><td>Novartis,multiple sites</td><td></td></tr><tr><td></td><td>MyPathway</td><td>Prospective</td><td>Advanced cancers</td><td> Genomic testing</td><td>NCT02091141</td><td>Genentech, US sites</td><td></td></tr><tr><td>2014</td><td>IMPACT2</td><td>Prospective, randomized</td><td>Metastatic cancer</td><td>Genomic testing</td><td>NCT02152254</td><td>MD Anderson Cancer Center</td><td></td></tr><tr><td>2014[125]</td><td>Pangea</td><td>Prospective</td><td>Gastro-esophageal adenocarcinoma</td><td>Tumor biomarker profiling/cell-free DNA</td><td></td><td>NCT02213289 University of Chicago</td><td></td></tr><tr><td>2015[126-129] 2015[12]</td><td>NCI-MATCH I-PREDICT</td><td>Prospective Prospective</td><td>Advanced cancers Advanced cancers including</td><td>NGS CGP</td><td>NCT02534675</td><td>NCT02465060 NCI,US sites</td><td>Ongoing study with</td></tr><tr><td></td><td></td><td>navigational</td><td>treatment-naive patients</td><td></td><td></td><td>UC San Diego Avera</td><td>preliminary results ( Table 1)</td></tr><tr><td>2016</td><td>DART</td><td>Prospective</td><td>Rare cancers</td><td>NGS correlational testing: whole genomic, transcriptome, liquid biopsy (ctDNA),and</td><td></td><td>NCT02834013 sWOG/NCI, multiple US sites</td><td></td></tr><tr><td>2016[130]</td><td>TAPUR</td><td>Prospective</td><td>Advanced cancers</td><td>immune signature Genomic analysis or IHC</td><td></td><td></td><td></td></tr><tr><td>2016 2017</td><td>DRUP</td><td>Prospective</td><td>Advanced cancers</td><td>NGS</td><td>NCT02925234</td><td>NCT02693535 ASCO, US sites Netherlands</td><td></td></tr><tr><td>2018</td><td>Pediatric MATCH</td><td>Prospective</td><td>Pediatric advanced Cancers</td><td>CLIA-certified molecular testing</td><td>NCT03155620</td><td>NCI-COG, US sites</td><td></td></tr><tr><td></td><td>Columbia University N-</td><td>Prospective</td><td>Metastatic cancer</td><td>Computational strategies (OncoTarget and</td><td></td><td>Columbia University</td><td></td></tr><tr><td></td><td>of-1 Clinical Trials</td><td></td><td></td><td>OncoTreat)</td><td></td><td></td><td></td></tr></table></body></html>

# Blood-derived circulating tumor cell (CTC) analysis

The presence of CTCs, which are epithelial tumor cells, has been independently associated with worse survival in several types of cancer [44–46]. For example, in a prospective, multicenter, double-blind study, the number of CTCs in patients with untreated metastatic breast cancer correlated with shorter progression-free survival (PFS) and overall survival (OS) [44]. CTCs may also be a predictive biomarker for chemotherapy and immunotherapy [45,47]. However, the use of CTCs in clinical practice has not been fully established [48]. Finally, serial CTC analyses might enable real-time surveillance of the disease. A comparative study of five prospective randomized phase III trials in 6081 patients with metastatic castration-resistant prostate cancer assessed the prognostic value of CTCs compared to prostate-specific antigen [49]. $\mathrm { C T C } \geq 0$ at baseline and at week 13 from treatment initiation was associated with OS. The investigators demonstrated that CTC monitoring was a robust and meaningful response endpoint for early-phase clinical trials in this setting [49].

# Transcriptomics

Transcriptomics refers to the study of RNA transcripts and their function. Transcriptomic analysis is performed using high-throughput technologies, including microarrays and RNA sequencing and it is a potentially valuable tool, particularly when there is discrepancy between genomic alterations and gene expression. Transcriptomics are utilized to identify prognostic and predictive gene expression signatures [50,51], to explore miRNAs and their role in mRNA regulation [52,53] and to identify the tissue of origin in cancer of unknown primary [54- –56]. The first solid tumor precision medicine trial to use transcriptomics in the clinic—WINTHER—compared RNA expression in tumors to that in adjacent normal tissue and demonstrated that transcriptomics increased the number of patients that could be matched to therapy [13]. Comparing tumor to normal tissue from the same patient may be necessary because of the large inter-patient variability in normal RNA expression. Other investigators have also used transcriptomics to select targeted treatments in patients with advanced solid tumors [57,58]. Challenges that prevent extensive use of transcriptomic biomarkers are degradation and fragmentation of RNA in formalin-fixed, paraffin-embedded tissue samples, complexity of required bioinformatic analysis of profiling data and low reproducibility of the results.

# Proteomics

Proteomic analysis using immunohistochemical and other assays of tumors from patients with refractory metastatic cancer led to the identification of molecular targets that could guide therapeutic decisions and was associated with longer PFS compared to the patients’ PFS with their prior therapy (using patients as their own controls) [1]. Proteomic assays are used in clinical practice to identify prognostic or predictive biomarkers for targeted treatments (hormone receptor expression, HER2 overexpression, ALK expression). However, the weaker correlation of proteomic markers, compared to genomic markers, with clinical outcomes suggests that technical issues should be addressed [24]. In a meta-analysis of phase 1 clinical trials of small molecules that used a genomic biomarker vs. those that used a protein biomarker, the median response rate was $4 1 \%$ vs. $2 5 \%$ , respectively $( \mathbf { p } = 0 . 0 5 )$ [24]. Ongoing studies with targeted therapies include correlative analyses using peripheral blood and tumor tissue to identify proteomic biomarkers of response or resistance to treatment (LEEomic, NCT03613220 and BABST-C, NCT03743428).

# Immunotherapy and cellular therapy

By reactivating the innate immune antitumor response, immunotherapy has provided a major breakthrough in oncology treatment [28,59]. Several novel approaches are currently being explored: checkpoint blockade, oncolytic viruses, cell-based products, modified cytokines, CD3-bispecific antibodies, vaccine platforms, and adoptive cell therapy [60].

# Checkpoint blockade

There are seven FDA-approved checkpoint inhibitors: ipilimumab, pembrolizumab, nivolumab, avelumab, cemiplimab, durvalumab, and atezolizumab. Selected patients with advanced disease have remarkable response, including durable complete remission (CR). Despite the significant benefit noted in patients with diverse tumor types treated with checkpoint inhibitors, approximately $8 0 \%$ of patients across cancers do not experience beneficial effects. In the era of precision medicine, genomics, transcriptomics and other technologies are employed for the identification of biomarkers that predict benefit from immunotherapy. Interestingly, biomarkers predicting checkpoint inhibitor responsiveness are genomic: high tumor mutational burden (TMB) [28,59,61], mismatch gene repair defects resulting in high microsatellite instability (MSI-H) (and, thus, high TMB) [29,62], PBRM1 alterations [63,64], and PDL1 amplification [65]. Specifically, TMB has been shown to predict clinical benefit from checkpoint inhibitors [28]. In an analysis of 151 of 1638 patients who were treated with immunotherapeutic regimens and had TMB evaluation, high $_ { , \geq 2 0 }$ mutations/mb) TBM was independently associated with significant improvement in PFS and OS compared to low to intermediate TMB [28]. Other studies have however questioned the use of TMB as a biomarker [66,67].

Given its strong association with response to immunotherapy, MSIH is an established biomarker for response to checkpoint inhibitors [68,69]. MSI-H tumors have high TMB, often accumulating $> ~ 1 0 0 0$ non-synonymous genomic mutations, leading to tumor-specific proteins, known as neoantigens. Due to high clinical benefit rates, immunotherapeutic regimens have been approved by the FDA for the treatment of patients with advanced MSI-H colorectal cancer [70–72] or MSI-H tumors, irrespective of the organ of origin [73]. Finally, defects in DNA proofreading proteins polymerase δ (POLD1) and polymerase ε (POLE) lead to increased TMB and are associated with response to immunotherapy [59,74,75]. For instance, of 4 patients with non–small cell lung cancer with deleterious mutations in POLD1 and POLE (whole-exome sequencing, [WES]), 3 patients with the highest TMB responded to pembrolizumab [59]. Defects in other DNA repair systems might also be associated with response to immunotherapy. The predictive role of homologous recombination deficiency (HRD) is being evaluated in various tumors, including breast and ovarian cancer. Early phase clinical trials demonstrating that these patients may benefit from the addition of immunotherapy to poly ADP-ribose polymerase (PARP) inhibitors, should be confirmed with additional studies [76,77].

Furthermore, PBRM1 molecular alterations are evaluated as genomic biomarkers predicting checkpoint inhibitor responsiveness. Specifically, PBRM1 alterations were evaluated in a study of 35 patients with metastatic renal cell cancer treated with anti-programmed death-1 (PD-1) regimens [63]. WES revealed loss-of-function (LOF) mutations in the PBRM1 gene that predicted response to immunotherapy. Notably, the PBRM1 gene encodes for a protein of the chromatin remodeling complex, possibly interfering with hypoxia, and immune signaling pathways [63].

Another biomarker that predicts benefit from immunotherapy is PDL1 amplification [65]. In a retrospective analysis, this marker was identified in $0 . 7 \%$ (843 of 118,187) patients of various tumor types and it did not always correlate with PD-L1 expression. Six of 9 $( 6 6 . 7 \% )$ patients with PD-L1-amplified solid tumors had an objective response to checkpoint inhibitors, and their median PFS was 15.2 months [65]. PDL1 expression, assessed by immunohistochemistry on tumor cells or immune cells can be used as a response marker, albeit a suboptimal one [78]. Approximately $2 0 \%$ of FDA approvals of immunotherapeutic agents are based on companion PD-L1 diagnostic testing [79].

Genomic markers may also predict resistance—loss of JAK2 and beta 2 microglobulin mutations [80]—or hyper-progression (accelerated progression) after checkpoint blockade—MDM2 amplification and EGFR alterations [81]. WES of tumor tissue from 4 patients with advanced melanoma whose disease was resistant to anti–PD1 therapy, demonstrated LOF mutations in genes involved in interferon-receptor signaling and in antigen presentation (JAK1/2, β2-microglobulin) [80]. Importantly, PTEN loss is associated with resistance to immunotherapy in patients with melanoma, suggesting that targeting the PI3K/AKT/ mTOR pathway may overcome resistance to immunotherapy [82]. In our opinion, it is plausible that when PI3K/AKT/mTOR pathway alterations or PTEN loss are the key drivers of the disease, immunotherapy may have limited, if any, antitumor activity. Similarly, STK11 mutations and $\beta$ -catenin pathway alterations are reportedly associated with resistance to immunotherapy [83,84].

In summary, the available biomarkers are insufficient to adequately predict response to immunotherapy. Novel strategies may enhance our ability to identify biomarkers longitudinally, incorporating ctDNA analysis [85] or tumor tissue immune, genomic, transcriptomic, and proteomic analysis.

# Adoptive cell therapy

Adoptive cell therapy (ACT) is an innovative personalized treatment approach that enhances a patient’s immune system leading to specific tumor cell killing. Immune cells derived from a patient’s blood or tissue are expanded in vitro and then reinfused into the patient. These immune cells may be reprogrammed to recognize tumor-specific antigens [60,86]. Types of ACT include tumor-infiltrating lymphocyte (TIL) therapy, chimeric antigen receptor (CAR) T-cell therapy, engineered Tcell receptor (TCR) therapy and natural killer (NK) cell therapy.

# TILs

ACT of TILs is based on the use of T-cells that have infiltrated a patient’s tumor. Autologous cells are being harvested and administered to patients after their expansion and activation. This approach has shown promising results in metastatic melanoma [87–90], nasopharyngeal, and cervical carcinoma [91,92]. In three sequential clinical trials in patients with metastatic melanoma who had failed standard therapy, the use of autologous TILs was associated with objective response rates of $4 9 \%$ , $5 2 \%$ , and $7 2 \%$ , respectively; durable CRs were reported in $2 2 \%$ (20 of 93) of patients; and clinical benefit was observed irrespectively of prior therapy [87]. Ongoing clinical trials assess the role of TIL therapy in various solid tumors (NCT03645928, NCT03935893, NCT03108495, NCT03083873).

# CAR T-cells

CAR T-cells are a type of adoptive T-cell therapy in which autologous T-lymphocytes are genetically engineered to recognize the antigens expressed on malignant cells [93]. Adoptive T-cell therapy has resulted in remarkably high rates of durable CR in hematologic malignancies, including in patients with refractory disease. Therefore, the FDA has approved CAR T-cells for the treatment of pediatric patients and young adults with relapsed/refractory B-cell precursor acute lymphoblastic leukemia (Kymriah™, https://www.fda.gov/drugs/ resources-information-approved-drugs/fda-approves-tisagenlecleuceladults-relapsed-or-refractory-large-b-cell-lymphoma) and adult patients with relapsed/refractory diffuse large B-cell lymphoma (Yescarta™, https://www.fda.gov/vaccines-blood-biologics/cellular-gene-therapyproducts/yescarta-axicabtagene-ciloleucel). CAR T-cells are currently being evaluated in solid tumors [94,95].

TCR therapy

This approach uses T-cell receptor (TCR) engineered T-cells, and involves retroviruses that enable integration of new TCR transgene targeting antigens, which are expressed at high levels on different cancers into the genome of T-cells [96]. TCR therapy has been assessed in hematologic and solid malignancies [97–101]. Current trials evaluate treatment-associated toxicity, binding affinity to tumor antigens and efficacy in carefully selected patients with increased tumor burden.

NK cell therapy

Natural killer (NK) cells are cytotoxic lymphocytes that play a critical role in innate immunity. NK cells do not cause graft-versus-host disease, which makes them promising candidates for cancer treatment. Treatment of relapsed/refractory acute myeloid leukemia with haploidentical NK cells and recombinant human interleukin-15 induced CR in $3 2 \%$ of patients [102]. Clinical trials are currently evaluating CAR-NK cells in hematologic (NCT03056339, NCT00995137) and solid (NCT03656705, NCT03383978) malignancies.

# Personalized vaccines (vaccinomics)

The accumulation of somatic mutations in cancer can generate cancer-specific neo-epitopes. Autologous T-cells often identify these neo-epitopes as foreign bodies, which makes them ideal cancer vaccine targets. Every cancer has its own unique mutations, but a small number of neo-antigens are shared between cancers. Theoretically, technological advances will soon result in rapid mapping of mutations within a genome, rational selection of vaccine targets such as neo-epitopes, and on-demand production of vaccines tailored to a patient's individual tumor. Alternatively, off-the-shelf vaccines for tumors with shared epitopes might also be exploitable.

Several personalized vaccines are currently being evaluated in clinical trials [103,104]. For example, investigators used computational prediction of neo-epitopes to design personalized RNA mutanome vaccines for patients with metastatic melanoma [103]. Two of the five patients treated had objective responses to the vaccine alone, while a third patient had a CR to treatment with the vaccine combined with PD1 blockade [103]. In another study of vaccine-induced polyfunctional $\mathrm { C D 4 + }$ and $\mathrm { C D 8 + }$ T-cells targeting unique neoantigens in patients with melanoma [104], four of six vaccinated patients had no recurrence at 25 months after vaccination [104].

Sipuleucel-T, the first FDA-approved therapeutic cancer vaccine, is produced via ex vivo activation of autologous peripheral-blood mononuclear cells by a recombinant fusion protein comprised of prostatic acid phosphatase and granulocyte–macrophage colony-stimulating factor [105]. Sipuleucel-T is used to treat metastatic castration-resistant prostate cancer on the basis of results of a randomized, double-blind, placebo-controlled phase III trial in which patients who received Sipuleucel-T had longer survival than those who received placebo (25.8 months vs. 21.7 months, respectively; $\begin{array} { r } { \mathbf { p } = \mathbf { 0 } . 0 3 , } \end{array}$ ) [105].

# Challenges and solutions for the optimal implementation of precision medicine

Genomic studies have unveiled the reality of tumors—they are tremendously heterogeneic and complex, and optimized therapy often does not result from classical clinical research and practice models.

Precision medicine studies (Tables 1 and 2) demonstrate the major challenges in designing trials for this new paradigm. First, the rate of matching patients to drugs in these trials ranges from $5 \%$ to $4 9 \%$ and is mostly in the $1 5 \%$ to $2 0 \%$ range. Failure to match patients is attributed to (i) enrollment of individuals with end-stage disease, who deteriorate or die early; (ii) use of small gene panels that yield limited actionable alterations; (iii) delays in receiving and interpreting genomic results;

and (iv) difficulty accessing targeted therapy drugs and/or limited drug availability. Some solutions provided by trials with higher matching rates, e.g., I-PREDICT 12 (matching rate, $4 9 \%$ , include: (i) use of clinical trial navigators and medication acquisition specialists; (ii) application of a large NGS panel with $> ~ 2 0 0$ genes; (iii) creation of justin-time electronic molecular tumor boards immediately upon physician request; and (iv) exploitation of biomarkers to match patients to chemotherapy, hormonal therapy, and immunotherapy (in addition to gene-targeted agents). The majority of these trials [2,3,12,24] have shown improvement in clinical outcomes when treatments are matched to drugs compared to when they are not. Importantly, malignancies have complicated molecular biology, and use of personalized combinations of drugs that address a higher percentage of the aberrations present in an individual cancer is associated with better outcomes than more limited matching [6,7,12,13].

Other major hurdles encountered in the implementation of precision medicine include the following: (i) Potential differences in response to matched therapy depending on histology and/or genomic co-alterations. In contrast to molecular abnormalities that predict tumor agnostic response to treatment (e.g., NTRK fusions, MSI-H) [27,71,73], selected genomic biomarkers are predictive in specific tumor histologies [106,107]. (ii) The heterogeneity, complexity, and constant evolution of genomic landscapes. Due to significant heterogeneity between primary tumor and metastatic sites, molecular profiling of tumor tissue obtained from a single lesion may not always be representative of the systemic disease [108,109]. Additionally, under the pressure of targeted treatments, tumor molecular profile constantly evolves, with emerging resistant clones and new molecular alterations driving disease progression [110,111]. (iii) The need to screen large numbers of patients in order to find specific/rare genomic defects (for instance, NTRK fusions) [27,106,107]. (iv) Incomplete biologic/molecular profiles with which to select therapy; suboptimal technology and resources to understand completely the drivers of cancer in individual patients; (v) Considerable delays in the activation of clinical trials; (vi) differences in the metabolism and adverse effects of study drugs in various ethnic groups; (vii) lack of agreement between assays from different diagnostic companies/laboratories; and (viii) most importantly, lack of access to drugs for patients with limited resources as well as excessive eligibility criteria that rule out large swaths of patients with real-world co-morbidities. Approximately $3 \mathrm { - } 5 \%$ of patients with cancer are enrolled on clinical trials and accrual is limited by overly restrictive eligibility criteria and limited access to drugs [112]. ASCO, the Friends of Cancer Research, and the FDA recommended to broaden eligibility criteria to allow more patients to participate in clinical trials and gain benefit from novel investigational therapies [113]; and consequently participants will be representative of the actual patient population, increasing generalizability of the results. Patient enrollment could be enhanced by national and worldwide collaborations, as shown in multi-institutional trials [114,115]. Finally, the Clinical Trials Transformation Initiative (CTTI), has been developed to examine the challenges and propose solutions to improve trial recruitment [116].

Several initiatives might help overcome the challenges introduced by our emerging understanding of cancer biology: (i) molecular profiling (tissue, blood) should be used at the time of diagnosis and during the course of the disease, the latter to monitor response and resistance; (ii) completion of molecular profiling should be expedited; and (iii) bioinformatic analysis should be optimized to include the key drivers of carcinogenesis.

With the current excitement about the promise of immunotherapy, a large proportion of patients are assigned to immunotherapy trials without undergoing molecular profiling or immune marker identification. Although a significant minority of these patients will experience a clinical benefit and prolonged survival, the majority will have disease progression and/or significant adverse events. Therefore, the incorporation of biomarkers into the selection of patients for immunotherapy needs to be optimized.

Finally, the immense potential of real-world data needs to be addressed. Validation of database information can be performed by comparing outcomes of clinical trials that led to approval with those in the database; if outcomes are similar, real-world data can then be used to rapidly predict new applications for medicines.

# Conclusions and future perspectives

Remarkable biotechnological advances are transforming cancer care. Tumor and cell-free DNA profiling using NGS, as well as proteomic and RNA analysis, and a better understanding of immune mechanisms are optimizing cancer treatment selection. A major challenge in the therapeutic management of patients with advanced metastatic cancer is the complexity of tumor biology. This complexity is attributed to highly variable patterns of genetic and epigenetic diversity and clonal architecture associated with spatial expansion, proliferative selfrenewal, migration, and invasion. The complexity is amplified by the dynamic, Darwinian evolutionary character of cancer cells, which undergo sequential searches for mechanisms to escape environmental constraints. Such cellular evolution involves the interplay of advantageous “driver” lesions, neutral or “passenger/hitchhiker” abnormalities, molecular changes in the tumor cells that increase the rate of other genomic anomalies, and modifications to the microenvironment and immune machinery that alter the fitness effects of other variables [117]. Strategies to address tumor complexity include targeting self-renewing cancer stem cells to overcome their plasticity and adaptability, impacting the microenvironment, and turning cancer into a chronic disease (using cytostatic drugs to suppress cell division and new mutations). The complicated nature of tumor biology is also the result of interactions between the tumor, host, and local ecosystem, including HLA type, genetic polymorphisms, microbiome, immune cell repertoire, and tumor microenvironment [118]. New strategies, some of which now have a proven track record, include gene-directed therapies and a host of immune-targeted approaches (e.g., checkpoint blockade, CAR Tcells, personalized vaccinomics) [118,119].

An overarching theme is that optimized therapy may require the utilization of combinations of drugs and/or strategies that attack the tumor from multiple angles. It is time to recognize the possibility that advanced computer implementation could generate real-world data that expand our understanding of cancer, rapidly identify new treatments, and create personalized drugs or immune therapies.

# Authors' contributions

All authors wrote and approved the paper.

#

NIH/NCI, award number P30 CA016672.

# Declaration of Competing Interest

Dr. Apostolia-Maria Tsimberidou has the following financial re  
lationships to disclose: Research Funding (Institution): Immatics,   
Parker Institute for Cancer Immunotherapy, Tempus, OBI Pharma, EMD   
Serono, Baxalta, ONYX, Bayer, Boston Biomedical, Placon Therapeutics,   
Karus Therapeutics, and Tvardi Therapeutics. Consulting or Advisory   
Role: Covance, Genentech, and Tempus. Dr. Elena Fountzilas has the following financial relationships to   
disclose: Travel grant from Merck and K.A.M Oncology/Hematology;   
stock ownership Deciphera Pharmaceuticals, Inc. Dr. Mina Nikanjam has the following financial relationships to   
disclose: Research Funding (Institution): Regeneron, Bristol Myers   
Squib, Immunocore, Idera, and Merck. Dr. Razelle Kurzrock has the following financial relationships to

disclose: Research Funding (Institution): Incyte, Genentech, Merck Serono, Pfizer, Sequenom, Foundation Medicine, Konica Minolta, Grifols, Biologic Dynamics, and Guardant. Consulting role: X-Biotech, Loxo, and Actuate Therapeutics. Speaker fees: Roche. Ownership interest: IDbyDNA and Curematch, Inc.

# References

[1] Von Hoff DD, Stephenson Jr. JJ, Rosen P, et al. Pilot study using molecular profiling of patients' tumors to find potential targets and select treatments for their refractory cancers. J Clin Oncol 2010;28:4877–83.   
[2] Tsimberidou AM, Iskander NG, Hong DS, et al. Personalized medicine in a phase I clinical trials program: the MD Anderson Cancer Center initiative. Clin Cancer Res 2012;18:6373–83.   
[3] Tsimberidou AM, Wen S, Hong DS, et al. Personalized medicine for patients with advanced cancer in the phase I program at MD Anderson: validation and landmark analyses. Clin Cancer Res 2014;20:4827–36.   
[4] Tsimberidou AM, Hong DS, Ye Y, et al. Initiative for Molecular Profiling and Advanced Cancer Therapy (IMPACT): An MD Anderson Precision Medicine Study. JCO Precis. Oncol 2017;2017..   
[5] Le Tourneau C, Delord JP, Goncalves A, et al. Molecularly targeted therapy based on tumour molecular profiling versus conventional therapy for advanced cancer (SHIVA): a multicentre, open-label, proof-of-concept, randomised, controlled phase 2 trial. Lancet Oncol 2015;16:1324–34.   
[6] Schwaederle M, Parker BA, Schwab RB, et al. Precision Oncology: The UC San Diego Moores Cancer Center PREDICT Experience. Mol Cancer Ther 2016;15:743–52.   
[7] Wheler JJ, Janku F, Naing A, et al. Cancer Therapy Directed by Comprehensive Genomic Profiling: A Single Center Study. Cancer Res 2016;76:3690–701.   
[8] Stockley TL, Oza AM, Berman HK, et al. Molecular profiling of advanced solid tumors and patient outcomes with genotype-matched clinical trials: the Princess Margaret IMPACT/COMPACT trial. Genome Med 2016;8:109.   
[9] Massard C, Michiels S, Ferte C, et al. High-Throughput Genomics and Clinical Outcome in Hard-to-Treat Advanced Cancers: Results of the MOSCATO 01 Trial. Cancer Discov 2017;7:586–95.   
[10] Hainsworth JD, Meric-Bernstam F, Swanton C, et al. Targeted Therapy for Advanced Solid Tumors on the Basis of Molecular Profiles: Results From MyPathway, an Open-Label, Phase IIa Multiple Basket Study. J Clin Oncol 2018;36:536–42.   
[11] Tredan O, Wang Q, Pissaloux D, et al. Molecular screening program to select molecular-based recommended therapies for metastatic cancer patients: analysis from the ProfiLER trial. Ann Oncol 2019;30:757–65.   
[12] Sicklick JK, Kato S, Okamura R, et al. Molecular profiling of cancer patients enables personalized combination therapy: the I-PREDICT study. Nat Med 2019;25:744–50.   
[13] Rodon J, Soria JC, Berger R, et al. Genomic and transcriptomic profiling expands precision cancer medicine: the WINTHER trial. Nat Med 2019;25:751–8.   
[14] Kim ES, Herbst RS, Wistuba II, et al. The BATTLE trial: personalizing therapy for lung cancer. Cancer Discov 2011;1:44–53.   
[15] Kris MG, Johnson BE, Berry LD, et al. Using multiplexed assays of oncogenic drivers in lung cancers to select targeted drugs. JAMA 2014;311:1998–2006.   
[16] Aisner DL, Sholl LM, Berry LD, et al. The Impact of Smoking and TP53 Mutations in Lung Adenocarcinoma Patients with Targetable Mutations-The Lung Cancer Mutation Consortium (LCMC2). Clin Cancer Res 2018;24:1038–47.   
[17] Papadimitrakopoulou V, Lee JJ, Wistuba II, et al. The BATTLE-2 Study: A Biomarker-Integrated Targeted Therapy Study in Previously Treated Patients With Advanced Non-Small-Cell Lung Cancer. J Clin Oncol 2016;34:3638–47.   
[18] Esserman LJ, Berry DA, DeMichele A, et al. Pathologic complete response predicts recurrence-free survival more effectively by cancer subset: results from the I-SPY 1 TRIAL–CALGB 150007/150012, ACRIN 6657. J Clin Oncol 2012;30:3242–9.   
[19] Andre F, Bachelot T, Commo F, et al. Comparative genomic hybridisation array and DNA sequencing to direct treatment of metastatic breast cancer: a multicentre, prospective trial (SAFIR01/UNICANCER). Lancet Oncol 2014;15:267–74.   
[20] Park JW, Liu MC, Yee D, et al. Adaptive Randomization of Neratinib in Early Breast Cancer. N Engl J Med 2016;375:11–22.   
[21] Rugo HS, Olopade OI, DeMichele A, et al. Adaptive Randomization of VeliparibCarboplatin Treatment in Breast Cancer. N Engl J Med 2016;375:23–34.   
[22] Wheler J, Lee JJ, Kurzrock R. Unique molecular landscapes in cancer: implications for individualized, curated drug combinations. Cancer Res 2014;74:7181–4.   
[23] Kurzrock R, Giles FJ. Precision oncology for patients with advanced cancer: the challenges of malignant snowflakes. Cell Cycle 2015;14:2219–21.   
[24] Schwaederle M, Zhao M, Lee JJ, et al. Association of Biomarker-Based Treatment Strategies With Response Rates and Progression-Free Survival in Refractory Malignant Neoplasms: A Meta-analysis. JAMA Oncol 2016;2:1452–9.   
[25] Rosario SR, Long MD, Affronti HC, Rowsam AM, Eng KH, Smiraglia DJ. Pan-cancer analysis of transcriptional metabolic dysregulation using The Cancer Genome Atlas. Nat Commun 2018;9:5330.   
[26] Long GV, Stroyakovskiy D, Gogas H, et al. Combined BRAF and MEK inhibition versus BRAF inhibition alone in melanoma. N Engl J Med 2014;371:1877–88.   
[27] Drilon A, Laetsch TW, Kummar S, et al. Efficacy of Larotrectinib in TRK FusionPositive Cancers in Adults and Children. N Engl J Med 2018;378:731–9.   
[28] Goodman AM, Kato S, Bazhenova L, et al. Tumor Mutational Burden as an Independent Predictor of Response to Immunotherapy in Diverse Cancers. Mol   
[29] Le DT, Uram JN, Wang H, et al. PD-1 Blockade in Tumors with Mismatch-Repair Deficiency. N Engl J Med 2015;372:2509–20.   
[30] Subbiah V, Kurzrock R. The Marriage Between Genomics and Immunotherapy: Mismatch Meets Its Match. Oncologist 2019;24:1–3.   
[31] Kurzrock R, Shtalrid M, Romero P, et al. A novel c-abl protein product in Philadelphia-positive acute lymphoblastic leukaemia. Nature 1987;325:631–5.   
[32] Kurzrock R, Gutterman JU, Talpaz M. The molecular genetics of Philadelphia chromosome-positive leukemias. N Engl J Med 1988;319:990–8.   
[33] Venter JC, Adams MD, Myers EW, et al. The sequence of the human genome. Science 2001;291:1304–51.   
[34] Herbst RS, Gandara DR, Hirsch FR, et al. Lung Master Protocol (Lung-MAP)-A Biomarker-Driven Protocol for Accelerating Development of Therapies for Squamous Cell Lung Cancer: SWOG S1400. Clin Cancer Res 2015;21:1514–24.   
[35] Pabla S, Conroy JM, Nesline MK, et al. Proliferative potential and resistance to immune checkpoint blockade in lung cancer patients. J Immunother Cancer 2019;7:27.   
[36] Jennings LJ, Arcila ME, Corless C, et al. Guidelines for Validation of NextGeneration Sequencing-Based Oncology Panels: A Joint Consensus Recommendation of the Association for Molecular Pathology and College of American Pathologists. J Mol Diagn 2017;19:341–65.   
[37] Li MM, Datto M, Duncavage EJ, et al. Standards and Guidelines for the Interpretation and Reporting of Sequence Variants in Cancer: A Joint Consensus Recommendation of the Association for Molecular Pathology, American Society of Clinical Oncology, and College of American Pathologists. J Mol Diagn 2017;19:4–23.   
[38] Genomic Profiling Tests Cleared by FDA. 2017. (Accessed 7/12/2019, at https:// www.cancer.gov/news-events/cancer-currents-blog/2017/genomic-profilingtests-cancer).   
[39] Salami SS, Singhal U, Spratt DE, et al. Circulating Tumor Cells as a Predictor of Treatment Response in Clinically Localized Prostate Cancer. JCO Precision Oncol 2019:1–9.   
[40] Abd Elmageed ZY, Yang Y, Thomas R, et al. Neoplastic reprogramming of patientderived adipose stem cells by prostate cancer cell-associated exosomes. Stem Cells 2014;32:983–97.   
[41] Chabon JJ, Simmons AD, Lovejoy AF, et al. Circulating tumour DNA profiling reveals heterogeneity of EGFR inhibitor resistance mechanisms in lung cancer patients. Nat Commun 2016;7:11815.   
[42] Dagogo-Jack I, Shaw AT. Tumour heterogeneity and resistance to cancer therapies. Nat Rev Clin Oncol 2018;15:81–94.   
[43] Merker JD, Oxnard GR, Compton C, et al. Circulating Tumor DNA Analysis in Patients With Cancer: American Society of Clinical Oncology and College of American Pathologists Joint Review. Arch Pathol Lab Med 2018.   
[44] Cristofanilli M, Budd GT, Ellis MJ, et al. Circulating tumor cells, disease progression, and survival in metastatic breast cancer. N Engl J Med 2004;351:781–91.   
[45] Hiltermann TJ, Pore MM, van den Berg A, et al. Circulating tumor cells in smallcell lung cancer: a predictive and prognostic factor. Ann Oncol 2012;23:2937–42.   
[46] Hofman V, Ilie MI, Long E, et al. Detection of circulating tumor cells as a prognostic factor in patients undergoing radical surgery for non-small-cell lung carcinoma: comparison of the efficacy of the Cell Search Assay and the isolation by size of epithelial tumor cell method. Int J Cancer 2011;129:1651–60.   
[47] Tamminga M, de Wit S, Hiltermann TJN, et al. Circulating tumor cells in advanced non-small cell lung cancer patients are associated with worse tumor response to checkpoint inhibitors. J Immunother Cancer 2019;7:173.   
[48] Rossi E, Fabbri F. CTCs 2020: Great Expectations or Unreasonable Dreams. Cells 2019;8.   
[49] Heller G, McCormack R, Kheoh T, et al. Circulating Tumor Cell Number as a Response Measure of Prolonged Survival for Metastatic Castration-Resistant Prostate Cancer: A Comparison With Prostate-Specific Antigen Across Five Randomized Phase III Clinical Trials. J Clin Oncol: Off J Am Soc Clin Oncol 2018;36:572–80.   
[50] Sparano JA, Gray RJ, Makower DF, et al. Adjuvant Chemotherapy Guided by a 21- Gene Expression Assay in Breast Cancer. N Engl J Med 2018;379:111–21.   
[51] Paik S, Shak S, Tang G, et al. A multigene assay to predict recurrence of tamoxifentreated, node-negative breast cancer. N Engl J Med 2004;351:2817–26.   
[52] Buffa FM, Camps C, Winchester L, et al. microRNA-associated progression pathways and potential therapeutic targets identified by integrated mRNA and microRNA expression profiling in breast cancer. Cancer Res 2011;71:5635–45.   
[53] Jacobsen A, Silber J, Harinath G, Huse JT, Schultz N, Sander C. Analysis of microRNA-target interactions across diverse cancer types. Nat Struct Mol Biol 2013;20:1325–32.   
[54] Michuda J, Igartua C, Taxter T, Bell JS, Pelossof R, White K. Transcriptome-based cancer type prediction for tumors of unknown origin. J Clin Oncol 2019;37:3081-.   
[55] Bridgewater J, van Laar R, Floore A, Van'T Veer L. Gene expression profiling may improve diagnosis in patients with carcinoma of unknown primary. Br J Cancer 2008;98:1425–30.   
[56] Tothill RW, Shi F, Paiman L, et al. Development and validation of a gene expression tumour classifier for cancer of unknown primary. Pathology 2015;47:7–12.   
[57] Weidenbusch B, Richter GHS, Kesper MS, et al. Transcriptome based individualized therapy of refractory pediatric sarcomas: feasibility, tolerability and efficacy. Oncotarget 2018;9:20747–60.   
[58] Worst BC, van Tilburg CM, Balasubramanian GP, et al. Next-generation personalised medicine for high-risk paediatric cancer patients - The INFORM pilot study. Eur J Cancer 2016;65:91–101.   
[59] Rizvi NA, Hellmann MD, Snyder A, et al. Cancer immunology. Mutational landnsitivity to PD-1 blockade in n mall cell lun Science 2015;348:124–8.   
[60] Rosenberg SA, Restifo NP. Adoptive cell transfer as personalized immunotherapy for human cancer. Science 2015;348:62–8.   
[61] Jhaveri KL, Wang XV, Makker V, et al. Ado-trastuzumab emtansine (T-DM1) in patients with HER2-amplified tumors excluding breast and gastric/gastroesophageal junction (GEJ) adenocarcinomas: results from the NCI-MATCH trial (EAY131) subprotocol Q. Ann Oncol 2019;30:1821–30.   
[62] Hellmann MD, Ciuleanu TE, Pluzanski A, et al. Nivolumab plus Ipilimumab in Lung Cancer with a High Tumor Mutational Burden. N Engl J Med 2018;378:2093–104.   
[63] Miao D, Margolis CA, Gao W, et al. Genomic correlates of response to immune checkpoint therapies in clear cell renal cell carcinoma. Science 2018;359:801–6.   
[64] Otto G. PBRM1 loss promotes tumour response to immunotherapy. Nat Rev Clin Oncol 2018;15:134–5.   
[65] Goodman AM, Piccioni D, Kato S, et al. Prevalence of PDL1 Amplification and Preliminary Response to Immune Checkpoint Blockade in Solid Tumors. JAMA Oncol 2018;4:1237–44.   
[66] Langer C, Gadgeel S, Borghaei H, et al. OA04.05 KEYNOTE- 021: TMB and Outcomes for Carboplatin and Pemetrexed With or Without Pembrolizumab for Nonsquamous NSCLC. J Thoracic Oncol 2019;14:S216.   
[67] Garassino M, Rodriguez-Abreu D, Gadgeel S, et al. OA04.06 Evaluation of TMB in KEYNOTE- 189: Pembrolizumab Plus Chemotherapy vs Placebo Plus Chemotherapy for Nonsquamous NSCLC. J Thoracic Oncol 2019;14:S216–7.   
[68] Marcus L, Lemery SJ, Keegan P, Pazdur R. FDA Approval Summary: Pembrolizumab for the Treatment of Microsatellite Instability-High Solid Tumors. Clin Cancer Res 2019;25:3753–8.   
[69] Kim ST, Cristescu R, Bass AJ, et al. Comprehensive molecular characterization of clinical responses to PD-1 inhibition in metastatic gastric cancer. Nat Med 2018;24:1449–58.   
[70] Overman MJ, McDermott R, Leach JL, et al. Nivolumab in patients with metastatic DNA mismatch repair-deficient or microsatellite instability-high colorectal cancer (CheckMate 142): an open-label, multicentre, phase 2 study. Lancet Oncol 2017;18:1182–91.   
[71] Le DT, Kim TW, Cutsem EV, et al. Phase II Open-Label Study of Pembrolizumab in Treatment-Refractory, Microsatellite Instability–High/Mismatch Repair-Deficient Metastatic Colorectal Cancer: KEYNOTE-164. J Clin Oncol 2020;38:11–9.   
[72] Overman MJ, Lonardi S, Wong KYM, et al. Durable Clinical Benefit With Nivolumab Plus Ipilimumab in DNA Mismatch Repair-Deficient/Microsatellite Instability-High Metastatic Colorectal Cancer. J Clin Oncol: Off J Am Soc Clin Oncol 2018;36:773–9.   
[73] Marabelle A, Le DT, Ascierto PA, et al. Efficacy of Pembrolizumab in Patients With Noncolorectal High Microsatellite Instability/Mismatch Repair-Deficient Cancer: Results From the Phase II KEYNOTE-158 Study. J Clin Oncol 2020;38:1–10.   
[74] Gong J, Wang C, Lee PP, Chu P, Fakih M. Response to PD-1 Blockade in Microsatellite Stable Metastatic Colorectal Cancer Harboring a POLE Mutation. J Natl Comprehensive Cancer Netw: JNCCN 2017;15:142–7.   
[75] van Gool IC, Eggink FA, Freeman-Mills L, et al. POLE Proofreading Mutations Elicit an Antitumor Immune Response in Endometrial Cancer. Clin Cancer Res 2015;21:3347–55.   
[76] Domchek S, Postel-Vinay S, Im S, et al. Ann Oncol 2019;30(suppl_5). v475–v532 101093/annonc/mdz253.   
[77] Konstantinopoulos PA, Waggoner S, Vidal GA, et al. Single-Arm Phases 1 and 2 Trial of Niraparib in Combination With Pembrolizumab in Patients With Recurrent Platinum-Resistant Ovarian Carcinoma. JAMA Oncol 2019;5:1141–9.   
[78] Patel SP, Kurzrock R. PD-L1 Expression as a Predictive Biomarker in Cancer Immunotherapy. Mol Cancer Ther 2015;14:847–56.   
[79] Davis AA, Patel VG. The role of PD-L1 expression as a predictive biomarker: an analysis of all US Food and Drug Administration (FDA) approvals of immune checkpoint inhibitors. J ImmunoTher Cancer 2019;7:278.   
[80] Zaretsky JM, Garcia-Diaz A, Shin DS, et al. Mutations Associated with Acquired Resistance to PD-1 Blockade in Melanoma. N Engl J Med 2016;375:819–29.   
[81] Kato S, Goodman A, Walavalkar V, Barkauskas DA, Sharabi A, Kurzrock R. Hyperprogressors after Immunotherapy: Analysis of Genomic Alterations Associated with Accelerated Growth Rate. Clin Cancer Res 2017;23:4242–50.   
[82] Peng W, Chen JQ, Liu $\mathrm { C } ,$ et al. Loss of PTEN Promotes Resistance to T CellMediated Immunotherapy. Cancer Discov 2016;6:202–16.   
[83] Koyama S, Akbay EA, Li YY, et al. STK11/LKB1 Deficiency Promotes Neutrophil Recruitment and Proinflammatory Cytokine Production to Suppress T-cell Activity in the Lung Tumor Microenvironment. Cancer Res 2016;76:999–1008.   
[84] Spranger S, Bao R, Gajewski TF. Melanoma-intrinsic β-catenin signalling prevents anti-tumour immunity. Nature 2015;523:231–5.   
[85] Said R, Guibert N, Oxnard GR, Tsimberidou AM. Circulating tumor DNA analysis in the era of precision oncology. Oncotarget 2020;11:188–211.   
[86] Schumacher TNM. T-cell-receptor gene therapy. Nat Rev Immunol 2002;2:512–9.   
[87] Rosenberg SA, Yang JC, Sherry RM, et al. Durable complete responses in heavily pretreated patients with metastatic melanoma using T-cell transfer immunotherapy. Clin Cancer Res: Off J Am Assoc Cancer Res 2011;17:4550–7.   
[88] Besser MJ, Shapira-Frommer R, Itzhaki O, et al. Adoptive transfer of tumor-infiltrating lymphocytes in patients with metastatic melanoma: intent-to-treat analysis and efficacy after failure to prior immunotherapies. Clin Cancer Res: Off J Am Assoc Cancer Res 2013;19:4792–800.   
[89] Andersen R, Donia M, Ellebaek E, et al. Long-Lasting Complete Responses in Patients with Metastatic Melanoma after Adoptive Cell Therapy with TumorInfiltrating Lymphocytes and an Attenuated IL2 Regimen. Clin Cancer Res: Off J Am Assoc Cancer Res 2016;22:3734–45.   
[90] Forget M-A, Haymaker C, Hess KR, et al. Prospective Analysis of Adoptive TIL Therapy in Patients with Metastatic Melanoma: Response, Impact of Anti-CTLA4, and Biomarkers to Predict Clinical Outcome. Clin Cancer Res: Off J Am Assoc Cancer Res 2018;24:4416–28.   
[91] Comoli P, Pedrazzoli P, Maccario ${ \mathrm { R } } ,$ et al. Cell therapy of stage IV nasopharyngeal carcinoma with autologous Epstein-Barr virus-targeted cytotoxic T lymphocytes. J Clin Oncol: Off J Am Soc Clin Oncol 2005;23:8942–9.   
[92] Stevanović S, Draper LM, Langhan MM, et al. Complete regression of metastatic cervical cancer after treatment with human papillomavirus-targeted tumor-infiltrating T cells. J Clin Oncol: Off J Am Soc Clin Oncol 2015;33:1543–50.   
[93] Maude SL, Frey N, Shaw PA, et al. Chimeric antigen receptor T cells for sustained remissions in leukemia. N Engl J Med 2014;371:1507–17.   
[94] ACTolog in Patients With Solid Cancers (ACTolog). 2016. (Accessed 6/24/2019, at https://clinicaltrials.gov/ct2/show/NCT02876510?cond $=$ actolog&rank ${ } = 1$ ).   
[95] Brown CE, Alizadeh D, Starr $\mathbb { R } ,$ et al. Regression of glioblastoma after Chimeric antigen receptor T-cell therapy. N Engl J Med 2016;375:2561–9.   
[96] Govers C, Sebestyén Z, Coccoris M, Willemsen RA, Debets R. T cell receptor gene therapy: strategies for optimizing transgenic TCR pairing. Trends Mol Med 2010;16:77–87.   
[97] Johnson LA, Morgan RA, Dudley ME, et al. Gene therapy with human and mouse T-cell receptors mediates cancer regression and targets normal tissues expressing cognate antigen. Blood 2009;114:535–46.   
[98] Morgan RA, Dudley ME, Wunderlich JR, et al. Cancer regression in patients after transfer of genetically engineered lymphocytes. Science (New York, NY) 2006;314:126–9.   
[99] Chodon T, Comin-Anduix B, Chmielowski B, et al. Adoptive transfer of MART-1 Tcell receptor transgenic lymphocytes and dendritic cell vaccination in patients with metastatic melanoma. Clin Cancer Res: Off J Am Assoc Cancer Res 2014;20:2457–65.   
[100] Kageyama S, Ikeda H, Miyahara Y, et al. Adoptive Transfer of MAGE-A4 T-cell Receptor Gene-Transduced Lymphocytes in Patients with Recurrent Esophageal Cancer. Clin Cancer Res: Off J Am Assoc Cancer Res 2015;21:2268–77.   
[101] Parkhurst MR, Yang JC, Langan RC, et al. T cells targeting carcinoembryonic antigen can mediate regression of metastatic colorectal cancer but induce severe transient colitis. Mol Ther 2011;19:620–6.   
[102] Cooley S, He F, Bachanova V, et al. First-in-human trial of rhIL-15 and haploidentical natural killer cell therapy for advanced acute myeloid leukemia. Blood Adv 2019;3:1970–80.   
[103] Sahin U, Derhovanessian E, Miller M, et al. Personalized RNA mutanome vaccines mobilize poly-specific therapeutic immunity against cancer. Nature 2017;547:222–6.   
[104] Ott PA, Hu Z, Keskin DB, et al. An immunogenic personal neoantigen vaccine for patients with melanoma. Nature 2017;547:217–21.   
[105] Kantoff PW, Higano CS, Shore ND, et al. Sipuleucel-T immunotherapy for castration-resistant prostate cancer. N Engl J Med 2010;363:411–22.   
[106] Hyman DM, Puzanov I, Subbiah V, et al. Vemurafenib in multiple nonmelanoma cancers with BRAF V600 mutations. N Engl J Med 2015;373:726–36.   
[107] Ross JS, Ali SM, Fasan O, et al. ALK fusions in a wide variety of tumor types respond to anti-ALK targeted therapy. Oncologist 2017;22:1444–50.   
[108] Lovly CM, Salama AKS, Salgia R. Tumor Heterogeneity and Therapeutic Resistance. Am Soc Clin Oncol Educ Book 2016:e585–93.   
[109] Gerlinger M, Rowan AJ, Horswell S, et al. Intratumor Heterogeneity and Branched Evolution Revealed by Multiregion Sequencing. N Engl J Med 2012;366:883–92.   
[110] Kobayashi S, Boggon TJ, Dayaram T, et al. EGFR mutation and resistance of nonsmall-cell lung cancer to gefitinib. N Engl J Med 2005;352:786–92.   
[111] Napolitano A, Vincenzi B. Secondary KIT mutations: the GIST of drug resistance and sensitivity. Br J Cancer 2019;120:577–8.   
[112] Murthy VH, Krumholz HM, Gross CP. Participation in cancer clinical trials: race-, sex-, and age-based disparities. JAMA 2004;291:2720–6.   
[113] Kim ES, Bruinooge SS, Roberts S, et al. Broadening Eligibility Criteria to Make Clinical Trials More Representative: American Society of Clinical Oncology and Friends of Cancer Research Joint Research Statement. J Clin Oncol 2017;35:3737–44.   
[114] Unger JM, Cook E, Tai E, Bleyer A. The Role of Clinical Trial Participation in Cancer Research: Barriers, Evidence, and Strategies. Am Soc Clin Oncol Educ Book 2016;35:185–98.   
[115] Trimble EL, Abrams JS, Meyer RM, et al. Improving cancer outcomes through international collaboration in academic cancer treatment trials. J Clin Oncol 2009;27:5109–14.   
[116] Huang GD, Bull J, Johnston McKee K, Mahon E, Harper B, Roberts JN. Clinical trials recruitment planning: A proposed framework from the Clinical Trials Transformation Initiative. Contemporary Clin Trials 2018;66:74–9.   
[117] Greaves M, Maley CC. Clonal evolution in cancer. Nature 2012;481:306–13.   
[118] Sahin U, Tureci O. Personalized vaccines for cancer immunotherapy. Science 2018;359:1355–60.   
[119] van Rooij N, van Buuren MM, Philips D, et al. Tumor exome analysis reveals neoantigen-specific T-cell reactivity in an ipilimumab-responsive melanoma. J Clin Oncol 2013;31:e439–42.   
[120] Lee J, Kim ST, Kim K, et al. Tumor Genomic Profiling Guides Patients with Metastatic Gastric Cancer to Targeted Treatment: The VIKTORY Umbrella Trial. Cancer Discov 2019;9:1388–405.   
[121] Folprecht G, Aust DE, Roth A, et al. Improving access to molecularly defined clinical trials for patients with colorectal cancer: The EORTC SPECTAcolor platform. J Clin Oncol 2015;33. 575-575.   
[122] Gerber DE, Oxnard GR, Mandrekar SJ, et al. ALCHEMIST: a clinical trial platform to bring genomic discovery and molecularly targeted therapies to early-stage lung cancer. J Clin Oncol 2015;33. TPS7583-TPS.   
[123] Aftimos PG, Antunes De Melo e Oliveira AM, Hilbers F, et al. 152OFirst report of AURORA, the breast international group (BIG) molecular screening initiative for metastatic breast cancer (MBC) patients (pts). Ann Oncol 2019;30.   
[124] Slosberg ED, Kang BP, Peguero J, et al. Signature program: a platform of basket trials. Oncotarget 2018;9:21383–95.   
[125] Joshi SS, Maron SB, Lomnicki S, et al. Personalized antibodies for gastroesophageal adenocarcinoma (PANGEA): A phase II precision medicine trial (NCT02213289). J Clin Oncol 2018;36:TPS198-TPS.   
[126] Krop IE, Jegede O, Grilley-Olson JE, et al. Results from molecular analysis for therapy choice (MATCH) arm I: Taselisib for PIK3CA-mutated tumors. J Clin Oncol 2018;36. 101-101.   
[127] Jhaveri KL, Wang XV, Makker V, et al. Ado-trastuzumab emtansine in patients with HER2-amplified tumors excluding breast and gastric/gastroesophageal junction adenocarcinomas: results from the NCI-MATCH trial (EAY131) subprotocol Q. Ann Oncol 2019 Nov 1;30(11):1821–30.   
[128] Chae YK, Vaklavas C, Cheng HH, et al. Molecular analysis for therapy choice (MATCH) arm W: Phase II study of AZD4547 in patients with tumors with aberrations in the FGFR pathway. J Clin Oncol 2018;36. 2503-2503.   
[129] Azad N, Overman M, Gray R, et al. Nivolumab is effective in mismatch repairdeficient noncolorectal cancers: results from Arm Z1D-A subprotocol of the NCIMATCH (EAY131) study. J Clin Oncol 2020 Jan 20;38(3):214–22.   
[130] Mangat PK, Halabi S, Bruinooge SS, et al. Rationale and Design of the Targeted Agent and Profiling Utilization Registry (TAPUR) Study. JCO Precis. Oncol 2018;2018..